--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Cairo
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "ca_marketkeep" }
DefineCharacter { name = "ca_shopkeep" }
DefineCharacter { name = "ca_pyramidskeep" }
DefineCharacter { name = "ca_citadelkeep" }
DefineCharacter { name = "ca_nilekeep" }
DefineCharacter { name = "ca_bridgekeep" }
DefineCharacter { name = "ca_gatekeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "cairo",
	available = false,
	ambient = "sfx/metropolitan_loop.ogg", 

	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_05", time=200000, loop=true, htile=true, path={{800,30},{700,30},{100,30},{0,30},}, },
		SpriteLayer { image="clouds_05", time=240000, loop=true, path={{1200,60},{700,60},{100,60},{-400,60}}, },
		
		-- Plane
		SpriteLayer { imagelist=portPlanes, scale=.25, hold=25000,
			path={{-85,-3},{15,104},{262,85},{366,64},{445,49},{630,26},{818,97},},
		},
	
--		EmptyBuilding { name="ca_nile", character={"ca_nilekeep"}, x=490+310/2,y=216+142/2, },
		GenericBuilding { name="ca_pyramids", character="ca_pyramidskeep", ambient="sfx/farm_loop.ogg", x=557+243/2,y=73+76/2, },
		SpriteLayer { image="ca_pyramidmask", x=491+309/2,y=101+69/2, },
		GenericBuilding { name="ca_citadel", character="ca_citadelkeep", ambient="sfx/other_loop.ogg", x=145+101/2,y=49+114/2, },
		SpriteLayer { image="ca_citadelmask", x=85+193/2,y=132+64/2, },
		
		-- Boats
		SpriteLayer { image="boat_01", scale=.4, hold=15000,bounce=true,
			path={{443,231},{469,236},{557,259},{630,276}},
		},
		
		EmptyBuilding { name="ca_gate", character={"ca_gatekeep" }, ambient="sfx/other_loop.ogg", x=0+167/2,y=170+197/2,},
		Shop { name="ca_shop", character="ca_shopkeep", x=393+114/2,y=190+177/2, },
		Market { name="ca_market", character="ca_marketkeep", x=161+116/2,y=187+184/2,
			inventory = {  mango = true, sugar=true, hazelnut=true, milk=true, lemon = true,} },
		EmptyBuilding { name="ca_bridge", character={"ca_bridgekeep" }, x=485+289/2,y=236+155/2,},
		
		-- camels
		SpriteLayer { image="camelwalk.xml", time=64000, scale=.38, hold=12000,bounce=true,
			path={{-40,345},{208,348},{626,345},{839,345},}, },
		SpriteLayer { image="camelwalk.xml", time=30000, scale=.42, hold=8000,
			path={{-63,351},{236,349},{512,349},{860,349},}, },

		-- Cars
		SpriteLayer { imagelist=portCars, scale=.6, time=16000,hold=4000,bounce=true,
			path={{-80,370},{100,370},{750,370},{880,370}} },

		SpriteLayer { imagelist=portCars, scale=.6, time=16000,hold=5000,bounce=true,
			path={{880,390},{750,390},{-80,390},{100,390}} },
			
		SpriteLayer { image="ca_foreground", x=43+568/2,y=208+214/2, },
	}
}
